require( "scripts/style.lua" );

SetPauseMenuCanShow(false);
SetConfirmExitCanShow(true);

local playername = gEnterNameValue;
local deleteselected = false;

if not playername or playername=="" then
    deleteselected = true;
    playername = GetString("enternameprompt") ;
end


MakeDialog
{
    Bitmap
    { 
        image="ui/surfaces/panel",
        x=kCenter,
        y=kCenter,
        
		SetStyle(CreateTextStyle(FontGame, 30, RedColor)),
		Text
		{
			name = "entername",
			x=160,y=20,w=kMax,h=30,
			flags = kVAlignCenter + kHAlignLeft,
			label= "entername",
		};

        SetStyle({}),
        Bitmap
        {
            image="ui/surfaces/textfield.png",
            x=kCenter,
            y=kCenter,
            
            TextEdit
            {
                font = {FontGame, 18, BlackColor},
                name = "nameedit",
                label = playername,
                enablewindow = "enterok",
                clearinitial = deleteselected,
                x=3,y=8,w=kMax-3,h=kMax,
                length=20,
                ignore = kIllegalNameChars
                
            };
        };

        SetStyle(CreatePushButtonStyle(StandardButtonGraphics, DefaultButtonSound)),
        Button
        {
            x=80,
            y=kMax-100,
            name="enterok",
            default=true,	-- Make this the default button
            command = 
                function()
                    local newname = GetLabel("nameedit");
                    newname = TrimSpaces(newname);
                    if (newname == "") then
                        DisplayDialog {
                            "scripts/ok.lua",
                            body ="incorrectname",
                            title = ""
                        };
                        SetFocus( "nameedit" )
                    else
                        if (newname ~= playername and IsNameInUse(newname)) then
                            DisplayDialog {
                                "scripts/ok.lua",
                                body ="nameinuse",
                                title = ""
                            };
                            SetFocus( "nameedit" )
                        else
                            CloseWindow(GetLabel("nameedit"));
                        end
                    end
                end,
		    SetStyle(CreateTextStyle(FontButtons, 26, WhiteColorAlpha128)),
		    CreateText(2,2,"ok", 0, 0),
		    SetStyle(CreateTextStyle(FontButtons, 26, BlackColor)),
		    CreateText(0,0,"ok", 0, 0),
        },
        
        SetStyle(CreatePushButtonStyle(StandardButtonGraphics, DefaultButtonSound)),
        Button
        {
            x=280,
            y=kMax-100,
            name="entercancel",
            command = 
                function()
                    CloseWindow(nil);
                end,
		    SetStyle(CreateTextStyle(FontButtons, 24, WhiteColor)),
		    CreateText(2,2,"cancel", 0, 0),
		    SetStyle(CreateTextStyle(FontButtons, 24, BlackColor)),
		    CreateText(0,0,"cancel", 0, 0),
        };
    },
}

SetFocus( "nameedit" );

if (deleteselected) then
    EnableWindow("enterok", false);
end